/**  @file bta_gaussian_blur.h
*
*    @brief This file implements a gaussian filter
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_GAUSSIAN_BLUR_H_INCLUDED
#define BTA_GAUSSIAN_BLUR_H_INCLUDED


typedef struct BTA_FltGaussianBlurInst {
	BTA_ChannelId channelToProcess;
	BTA_ChannelId channelIdResult;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltGaussianBlurInst;


BTA_Status BFLTgaussianBlurInit(BTA_FltGaussianBlurConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTgaussianBlurClose(BTA_FltHandle *handle);
BTA_Status BFLTgaussianBlurApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
